/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RemoveByName;

public class RemoveByNameTest
extends AbstractFilterTest {
    public RemoveByNameTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return this.getFilter("^.*id$", false);
    }

    protected Filter getFilter(String expression, boolean invert) {
        RemoveByName filter = new RemoveByName();
        filter.setExpression(expression);
        filter.setInvertSelection(invert);
        return filter;
    }

    public void testTypical() {
        this.m_Filter = this.getFilter("^String.*", false);
        Instances result = this.useFilter();
        RemoveByNameTest.assertEquals(this.m_Instances.numAttributes() - 2, result.numAttributes());
        RemoveByNameTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
    }

    public void testTypicalWithClass() {
        this.m_Instances.setClassIndex(1);
        this.m_Filter = this.getFilter("^Nominal.*", false);
        Instances result = this.useFilter();
        RemoveByNameTest.assertEquals(this.m_Instances.numAttributes() - 1, result.numAttributes());
        RemoveByNameTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
    }

    public void testTypicalInverted() {
        this.m_Filter = this.getFilter(".*Att2$", true);
        Instances result = this.useFilter();
        RemoveByNameTest.assertEquals(3, result.numAttributes());
        RemoveByNameTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
    }

    public static Test suite() {
        return new TestSuite(RemoveByNameTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(RemoveByNameTest.suite());
    }
}

